import { Navigation, Mail, Phone, MapPin, Clock, Instagram, Facebook, Twitter } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <div className="footer-logo-circle">
                <Navigation className="footer-logo-icon" size={24} strokeWidth={2.5} />
              </div>
              <h2 className="footer-logo-text">Путеводитель</h2>
            </div>
            <p className="footer-description">
              Откройте для себя удивительные места с нашими профессиональными гидами. 
              Незабываемые экскурсии по историческим, культурным и природным достопримечательностям.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link">
                <Instagram size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Facebook size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Twitter size={20} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Навигация</h3>
            <ul className="footer-links">
              <li><a href="/">Мои экскурсии</a></li>
              <li><a href="/book">Записаться</a></li>
              <li><a href="#">Популярные маршруты</a></li>
              <li><a href="#">О нас</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={16} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} strokeWidth={2} />
                <a href="mailto:info@tours.ru">info@tours.ru</a>
              </li>
              <li>
                <MapPin size={16} strokeWidth={2} />
                <span>Москва, ул. Путешественников, 15</span>
              </li>
              <li>
                <Clock size={16} strokeWidth={2} />
                <span>Ежедневно: 09:00 - 20:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 Путеводитель. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer
